' PicBasic Pro test program for LAB-X4 (12F675)

@	device  pic12F675, intrc_osc, wdt_on, pwrt_on, mclr_off, protect_off

Include "modedefs.bas"		' Mode definitions for Serout

Define	OSCCAL_1K	1	' Calibrate internal oscillator

' Alias pins
LED	Con	0		' Alias GPIO.0 to LED
LCD	Var	GPIO.1		' LCD TX pin
PB	Var	GPIO.3		' Alias GPIO.3 to push button

' Allocate variables
adval	var	byte		' Create adval to store result


	ANSEL = %00001000	' Set AN3 analog, rest digital
	CMCON = 7		' Analog comparators off

	Pause 500		' Wait .5 second for LCD to init


loop:	ADCIN 3, adval		' Read channel 3 to adval

	Serout LCD,T2400,[$fe, 1]	' Clear screen
	Serout LCD,T2400,["Pot = ", #adval]	' Display the decimal value  

	If PB = 0 Then		' If button pressed...
		Low LED		' Turn on LED
	Else
		High LED	' Turn off LED
	Endif

	Pause 200		' Do it all about 5 times a second

	Goto loop		' Do it forever

	End
